//
//  CSCondition.h
//  iPartition
//
//  Created by Chris Suter on 18/11/2009.
//  Copyright 2009 Coriolis Systems. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#ifndef CSCONDITION_CHECKING
#define CSCONDITION_CHECKING 1
#endif

@interface CSCondition : NSObject <NSLocking> {
  pthread_mutex_t mutex;
  pthread_cond_t condition;
  NSString *name;

#if CSCONDITION_CHECKING
  pthread_t thread_with_lock;
#endif
}

- (void)wait;
- (BOOL)waitUntilDate:(NSDate *)limit;
- (void)signal;
- (void)broadcast;
- (BOOL)tryLock;

@end
